import java.util.*;
import java.awt.*;

public class Motor3D{
    Vector mundos = new Vector();
   
    //Graphics tele = null;

    Camara camara = null;

    public Motor3D() {
       
    }

    public Motor3D(Vector mundos){
       
        this.mundos = mundos;
    }

    //public void setContextoGraphico( Graphics g ){ this.tele = g; }
    public Camara getCamara(){ return this.camara; }
    public void setCamara (Camara camara){ this.camara = camara; }

    public void addMundo( Mundo mundo ){
        //Salida.salida("Motor3D: addFigura (" + figura.caras.size() + " caras)");
        
        this.mundos.insertElementAt(mundo,0);
    }

    public void removeMundo( int numMundo ){
        this.mundos.removeElementAt(numMundo);
    }
    public void removeMundo( Object numMundo ){
        this.mundos.removeElement(numMundo);
    }


    public Vector3D rotarPunto( Vector3D punto, Vector3D rotacion ){
        Vector3D nVector3D = new Vector3D();
        //uso de temporales:
        float nx, ny, nz;

        //inicializo la copia:
        nVector3D.x = punto.x;
        nVector3D.y = punto.y;
        nVector3D.z = punto.z;

        //rotamos el vertice:
        //sobre el eje z:
        nx = (float)( nVector3D.x * Math.cos( rotacion.z ) - nVector3D.y * Math.sin( rotacion.z ) );
        ny = (float)( nVector3D.y * Math.cos( rotacion.z ) + nVector3D.x * Math.sin( rotacion.z ) );

        //sobre el eje x:
        nVector3D.y = (float) ( ny * Math.cos( rotacion.x) - nVector3D.z * Math.sin( rotacion.x ) );
        nVector3D.z = (float) ( ny * Math.sin( rotacion.x) + nVector3D.z * Math.cos( rotacion.x ) );

        //sobre el eje y:
        nz = (float)( nVector3D.z * Math.cos( rotacion.y) - nx * Math.sin( rotacion.y ) );
        nx = (float)( nVector3D.z * Math.sin( rotacion.y) + nx * Math.cos( rotacion.y ) );

        nVector3D.z = nz;
        nVector3D.x = nx;

        return nVector3D;
    }

    public Figura getFiguraTransformada(Figura figura, Mundo mundo){
       // Salida.salida("Motor3D: getFiguraTransformada()");
        Vector nCaras = new Vector();
        Enumeration enumCaras = figura.caras.elements();
        while(enumCaras.hasMoreElements()){
            Cara cara = (Cara)enumCaras.nextElement();
            
           // if(cara==null) //System.out.println("cara nula");
           // if(cara.vertices==null) //System.out.println("vertices nulo");
           
            Cara nCara2 = new Cara( cara );

            

            
            for(int n=0; n<cara.vertices.length ; n++){

                //primero uso sus transformaciones-----

                //rotamos el punto
                Vector3D nVector3D = this.rotarPunto( cara.vertices[n], figura.rotacion );

                //transladamos el vertice:
                nVector3D.x = nVector3D.x + figura.translacion.x;
                nVector3D.y = nVector3D.y + figura.translacion.y;
                nVector3D.z = nVector3D.z + figura.translacion.z;

                //luego las del mundo-------------

   
                nCara2.vertices[n] = new Vector3D();

                //inicializo la copia:
                nCara2.vertices[n].x = nVector3D.x;
                nCara2.vertices[n].y = nVector3D.y;
                nCara2.vertices[n].z = nVector3D.z;

                //rotamos el vertice:

                nCara2.vertices[n] = this.rotarPunto( nVector3D, mundo.rotacion );

               

                //transladamos el vertice:
                nCara2.vertices[n].x = nCara2.vertices[n].x + mundo.translacion.x;
                nCara2.vertices[n].y = nCara2.vertices[n].y + mundo.translacion.y;
                nCara2.vertices[n].z = nCara2.vertices[n].z + mundo.translacion.z;

            }
            
            nCaras.addElement( nCara2 );

        }
        Figura nFigura = new Figura(nCaras);
       // Salida.salida("figura translacion=" + figura.translacion.toString() );
        //Salida.salida("mundo translacion=" + mundo.translacion.toString() );
        nFigura.transladar( figura.translacion );
        nFigura.transladar( mundo.translacion );
        //Salida.salida("nFigura translacion=" + nFigura.translacion.toString() );
        nFigura.translacion = 
            this.rotarPunto( 
                nFigura.translacion,
                mundo.rotacion ) ;
        //Salida.salida("nFfigura translacion final=" + nFigura.translacion.toString() );

        
        
        return nFigura;
    }

    public void pintarFigura( Figura figura, Graphics tele ){
       // Salida.salida("Motor3D: pintarFigura");
        Enumeration enumCaras = figura.caras.elements();
        while(enumCaras.hasMoreElements()){
            Cara cara = (Cara)enumCaras.nextElement();
            int vertices_x[] = new int[cara.numVertices];
            int vertices_y[] = new int[cara.numVertices];
            if( this.isVisible( cara )) { //esta visible??
            
                for (int n=0; n<cara.numVertices; n++){
                    

                    vertices_x[n] = (int) ( ( (cara.vertices[n].x * this.camara.lente_x ) / (cara.vertices[n].z) ) + 200 );
                    vertices_y[n] = (int) ( ( (cara.vertices[n].y * this.camara.lente_y ) / (cara.vertices[n].z) ) + 150 );
                   /* Salida.salida("Motor3D: " + 
                                  cara.vertices[n].x + "," + 
                                  cara.vertices[n].y + "," +
                                  cara.vertices[n].z + "," + " = " +
                                  vertices_x[n] + "," +
                                  vertices_y[n] );*/
                }
               // Salida.salida("Motor3D: pintando poligono:");
               // for (int n=0; n<cara.vertices.length; n++)
                //    Salida.salida("\t " + vertices_x[n] + "," + vertices_y[n]); 
                
                switch ( cara.estilo ){
                    case Cara.FILL :
                       // Salida.salida("Motor3D: pintando cara FILL");
                        tele.setColor( cara.colorRelleno );
                        tele.fillPolygon(vertices_x, vertices_y, cara.numVertices);
                        break;

                    case Cara.FILL_MALLA :
                        tele.setColor( cara.colorRelleno );
                        tele.fillPolygon(vertices_x, vertices_y, cara.numVertices);

                    case Cara.MALLA :
                        tele.setColor( cara.colorMalla );
                        tele.drawPolygon(vertices_x, vertices_y, cara.numVertices);
                        break;
                }

                //this.imprimirNumeros( vertices_x, vertices_y, tele );

            }
        }
    }

    public void imprimirNumeros( int[] x, int[] y, Graphics tele ){
        tele.setColor( Color.red );
        for( int n=0; n<x.length; n++){
            tele.drawString( ""+n, x[n], y[n] );
        }
    }

    public void pintarTodo(Graphics tele){
        //Salida.salida("Motor3D: pintarTodo..mundos " + this.mundos.size() );
        Enumeration enumMundos = this.mundos.elements();

        while ( enumMundos.hasMoreElements() ){
            
            Vector figuras = this.getFigurasTransformadas( (Mundo)enumMundos.nextElement() );
            
            
            Enumeration enumFiguras = figuras.elements();
            while (enumFiguras.hasMoreElements()){
                Figura figura = (Figura)enumFiguras.nextElement();
                pintarFigura( 
                    this.ordenarCaras( figura ) ,
                    tele );
            }
        }

    }

    public Vector getFigurasTransformadas( Mundo mundo ){
        Salida.salida("Motor3D.getFigurasTransformadas...original:");
        this.imprimirZetas( mundo.figuras );
        Vector figuras = new Vector();
        Enumeration enumFiguras = mundo.figuras.elements();
        while (enumFiguras.hasMoreElements()){
            Figura fOriginal = (Figura)enumFiguras.nextElement();
            Figura nFigura = 
                this.getFiguraTransformada(
                    fOriginal,
                    mundo ) ;



            figuras.addElement(nFigura);
        }
        this.ordenarFiguras( figuras );

        Salida.salida("Motor3D.getFigurasTransformadas...resultado:");
        this.imprimirZetas( figuras );

        return figuras;
    }



    public boolean isVisible( Cara cara ){
        float normal = 
            ( cara.vertices[2].x * ( ( cara.vertices[0].z * cara.vertices[1].y ) - ( cara.vertices[0].y * cara.vertices[1].z ) ) ) +
            ( cara.vertices[2].y * ( ( cara.vertices[0].x * cara.vertices[1].z ) - ( cara.vertices[0].z * cara.vertices[1].x ) ) ) +
            ( cara.vertices[2].z * ( ( cara.vertices[0].y * cara.vertices[1].x ) - ( cara.vertices[0].x * cara.vertices[1].y ) ) );

        if (normal>0){
            //Salida.salida("NO visible");
            return false;
        } else {
            //Salida.salida("visible");
            return true;
        }
    }

    public float zMasProfunda( Cara cara ){
        float masProfundo = cara.vertices[0].z;
        for( int n=1; n<cara.vertices.length; n++ ){
            if( masProfundo > cara.vertices[n].z ) 
                masProfundo = cara.vertices[n].z;
        }
        return masProfundo;
    }

    public float zMasProxima( Cara cara ){
        float masProfundo = cara.vertices[0].z;
        for( int n=1; n<cara.vertices.length; n++ ){
            if( masProfundo < cara.vertices[n].z ) 
                masProfundo = cara.vertices[n].z;
        }
        return masProfundo;
    }

    public void imprimirZetas( Vector figuras ){
        for( int n=0; n<figuras.size(); n++ )
            Salida.salida("\t"+( (Figura)figuras.elementAt(n) ).translacion.z );
    }

   


    public Vector ordenarFiguras( Vector figuras ){
        Salida.salida("Motor3D.ordenarFiguras..antes----");
        this.imprimirZetas( figuras );
        
        for( int n=0; n<figuras.size(); n++ ){
            for( int nn=n; nn<figuras.size(); nn++ ){
                if( 
                    ( (Figura)figuras.elementAt(n) ).translacion.z >
                    ( (Figura)figuras.elementAt(nn) ).translacion.z )
                    this.intercambiar( figuras , n, nn );
            }
        }
        ////System.out.println("despues");
        //this.imprimirZetas( figura );


        Salida.salida("Motor3D.ordenarFiguras..despues----");
        this.imprimirZetas( figuras );

        return figuras;
    }


    public Figura ordenarCaras ( Figura figura ){
        ////System.out.println("antes");
        //this.imprimirZetas( figura );

        for( int n=0; n<figura.caras.size(); n++ ){
            for( int nn=n; nn<figura.caras.size(); nn++ ){
                if( 
                    this.zMasProxima( (Cara)figura.caras.elementAt(n) ) >
                    this.zMasProxima( (Cara)figura.caras.elementAt(nn) ) )
                    this.intercambiar( figura.caras , n, nn );
            }
        }
        ////System.out.println("despues");
        //this.imprimirZetas( figura );
        return figura;
    }

    public void imprimirZetas( Figura figura ){

        //for(int n=0; n<figura.caras.size(); n++)
            //System.out.println("[" + n + "]=" + this.zMasProfunda( ( (Cara)figura.caras.elementAt(n) ) ) );
    }


    public void intercambiar( Vector caras, int indice1, int indice2 ){
        Object cara1 = caras.elementAt( indice1 );
        Object cara2 = caras.elementAt( indice2 );

        caras.insertElementAt( cara1, indice2 );
        caras.remove( indice2 + 1 );
        
        caras.insertElementAt( cara2, indice1 );
        caras.remove( indice1 + 1 );
    }

    
}
